/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于控件接口
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2019.11.8
 *      内容 : 所有代码
 *************************************************************************************************/

/************************************************************************************************
 * 类型:
 *    控件对象
 * 功能:
 *    根据提供的json数组生成控件列表
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 例子：
 *    NA
 * 备注：
 *    五种日志类型 DEBUG|INFOR| WARN|ERROR|FATAL
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2019.11.8
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_ui_item_toggle_click(id, val) {
    console.log(id)
    alert('id:' + id)
}

function mc_ui_item_grp() {
    var obj_param_rsp = new mc_sdk_param();
    var ui_col_cnt_def = 3 //默认列数
    var str_dom_html = ""; //返回的控件dom
    var str_json_txt_re = ""
    var m_obj_lang_data = [];
    var obj_combo_mode_def = {} //存储控件合并模式的对象
    // 定义item控件定义创建的对象


    function get_lang_trans(str_key) {
        if (typeof str_key !== "string" || 0 == str_key.length) {
            return "";
        }

        var str_ret_val = m_obj_lang_data[str_key.toLocaleUpperCase()];
        if (typeof str_ret_val !== "string" || 0 === str_ret_val.length) {
            return str_key;
        }
        return str_ret_val;
    }


    // 判断可选参数存在时执行的合并/不合并函数
    function set_obj_combo_mode(b_combo, fun_name, val, obj_rgb_combo, obj_rgb_no_combo) {
        if (obj_rgb_combo.hasOwnProperty(fun_name) || obj_rgb_no_combo[0].hasOwnProperty(fun_name)) {
            // if ("undefined" !== typeof obj_rgb_combo[fun_name] || "undefined" !== typeof obj_rgb_no_combo[0]) {
            if (b_combo) {
                obj_rgb_combo[fun_name](val);
            } else {
                for (var i = 0; i < obj_rgb_no_combo.length; i++) {
                    obj_rgb_no_combo[i][fun_name](val);
                }
            }
        } else {
            return false
        }
    }

    // 根据ui_type值创造不同的实例
    function new_ui_type_fun(val) {
        var arr_item_type = {
            'EDIT': mc_ui_edit,
            'STEP_EDIT': mc_ui_step_edit,
            'OPTION': mc_ui_option,
            'SLIDER': mc_ui_slider,
            'TOGGLE': mc_ui_toggle,
        }
        return new arr_item_type[val]
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    封装设置控件的函数,返回生成的dom
     * 参数:
     *    @param { Promise<string> } 需要生成控件dom的 控件字符串
     * 返回：
     *    NA
     * 例子：
     *    NA
     * 备注：
     *    1.输入的字符串参数需要调用mc_sdk_param接口转换成json对象
     *    2.处理的是输入的 PARAMS 参数
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.11.8
     *      内容 : 所有代码
     ************************************************************************************************/
    function set_json_dom(str_json_txt) {
        if ("string" !== typeof str_json_txt) {
            return false
        }
        obj_param_rsp.set_json(str_json_txt);
        var ui_chip_cnt = obj_param_rsp.get_param_cnt();
        console.log(JSON.parse(obj_param_rsp.get_json()).PARAMS);

        // 所有控件的组合html_dom列表
        var str_item_dom_list = "";
        console.log(obj_combo_mode_def)

        var mc_item_placeholder_div //占位的div
        for (var idx = 0; idx < ui_chip_cnt; idx++) {
            // 获取"NAME_ID" 和 VALUE
            var str_param_name = obj_param_rsp.get_param_name(idx);
            var str_param_value = obj_param_rsp.get_param_value(str_param_name);

            //获取属性参数数组的长度(PARAM[i].ATTEIBUTE里面的数组)
            var ui_attr_cnt = obj_param_rsp.get_attr_cnt(str_param_name);

            // 控件的属性组合(PARAM[i].ATTRIBUTE)
            var ary_attr_ary = {};
            for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
                var str_attr_name = obj_param_rsp.get_attr_name(
                    str_param_name,
                    idx_attr
                );

                var str_attr_value = obj_param_rsp.get_attr_val(
                    str_param_name,
                    str_attr_name
                );

                //存储ATTRIBUTE
                ary_attr_ary[str_attr_name] = str_attr_value;
            }

            // 定义对象：控件前面部分对象(控件名)，控件本身对象，控件后面对象(单位)
            var obj_item_name_lable = new mc_ui_lab();
            var obj_item_unit_lable = new mc_ui_lab();

            var obj_item_def_mode_rgb = {}
            var obj_item_def_mode_r = {}
            var obj_item_def_mode_g = {}
            var obj_item_def_mode_b = {}

            // 获取param_name对应的语言表
            var str_param_name_trans = get_lang_trans(str_param_name);

            // 设置控件默认值
            obj_item_name_lable.set_val(str_param_name_trans);

            // 添加标签样式内容
            obj_item_name_lable.set_add_css("lable_margin_left");
            obj_item_unit_lable.set_add_css("lable_margin_left");

            // 获取属性为"UI_TYPE"的值;判断控件模式是否合并(默认不合并),创建相应的 判断控件类型对象
            var str_attr_ui_type_value = obj_param_rsp.get_attr_val(str_param_name, "UI_TYPE");
            var b_combo = false;
            if (typeof obj_combo_mode_def[str_param_name] !== "undefined") {
                b_combo = obj_combo_mode_def[str_param_name]
            }
            if (b_combo) {
                obj_item_def_mode_rgb = new new_ui_type_fun(str_attr_ui_type_value)
            } else {
                obj_item_def_mode_r = new new_ui_type_fun(str_attr_ui_type_value)
                obj_item_def_mode_g = new new_ui_type_fun(str_attr_ui_type_value)
                obj_item_def_mode_b = new new_ui_type_fun(str_attr_ui_type_value)
            }

            // 如果value值为rgb格式
            var str_param_value_rgb = str_param_value
            if (str_param_value.indexOf("=") !== -1) {
                str_param_value_split = str_param_value.split(",")
                var str_param_value_rgb = []
                for (var i = 0; i < str_param_value_split.length; i++) {
                    str_param_value_rgb.push(str_param_value_split[i].slice(2))
                }
            }

            // 设置控件的的value值
            if (b_combo) {
                if (str_param_value_rgb && str_param_value.indexOf("=") !== -1) {
                    obj_item_def_mode_rgb.set_val(str_param_value_rgb[0][0])
                } else {
                    obj_item_def_mode_rgb.set_val(str_param_value)
                }
            } else {
                if (str_param_value_rgb && str_param_value.indexOf("=") !== -1) {
                    obj_item_def_mode_r.set_val(str_param_value_rgb[0])
                    obj_item_def_mode_g.set_val(str_param_value_rgb[1])
                    obj_item_def_mode_b.set_val(str_param_value_rgb[2])
                } else {
                    obj_item_def_mode_r.set_val(str_param_value)
                    obj_item_def_mode_g.set_val(str_param_value)
                    obj_item_def_mode_b.set_val(str_param_value)
                }
            }

            // TOGGLE触发事件
            if ('TOGGLE' === str_attr_ui_type_value) {
                if (obj_item_def_mode_rgb.hasOwnProperty('on_click')) {
                    obj_item_def_mode_rgb.on_click = mc_ui_item_toggle_click;
                } else {
                    obj_item_def_mode_r.on_click = mc_ui_item_toggle_click;
                    obj_item_def_mode_g.on_click = mc_ui_item_toggle_click;
                    obj_item_def_mode_b.on_click = mc_ui_item_toggle_click;
                }
            }


            //每一个返回的html标签：控件名，控件本身，控件单位
            var str_item_name = "";
            var str_item_itself = "";
            var str_item_tail = "";

            /*
             * 判断控件的一些可选属性显示
             * 可选属性有 VAL_TYPE | DESCRIPT_ID |  MIN_VAL | MAX_VAL  |ARRAY | STEP | TAIL_ID_LIST
             */
            // VAL_TYPE： 显示数据类型，如整数，浮点数，字串等
            var str_attr_val_type_value = obj_param_rsp.get_attr_val(str_param_name, "VAL_TYPE");
            if ('undefined' !== typeof str_attr_val_type_value) {
                // obj_item_def_mode_r.set_val_type(str_attr_val_type_value);
                set_obj_combo_mode(
                    b_combo,
                    'set_val_type',
                    str_attr_val_type_value,
                    obj_item_def_mode_rgb,
                    [obj_item_def_mode_r, obj_item_def_mode_g, obj_item_def_mode_b]
                )
            }

            // 显示数据含义，鼠标放置控件上时显示
            var str_attr_val_descript_id = obj_param_rsp.get_attr_val(str_param_name, "DESCRIPT_ID");
            if ('undefined' !== typeof str_attr_val_descript_id) {
                set_obj_combo_mode(
                    b_combo,
                    'set_title',
                    str_attr_val_descript_id,
                    obj_item_def_mode_rgb,
                    [obj_item_def_mode_r, obj_item_def_mode_g, obj_item_def_mode_b]
                )
            }

            // 显示数据最小值， 整数，浮点数时有效
            var str_attr_val_min_val = obj_param_rsp.get_attr_val(str_param_name, "MIN_VAL");
            if ('undefined' !== typeof str_attr_val_min_val) {
                set_obj_combo_mode(
                    b_combo,
                    'set_min_val',
                    str_attr_val_min_val,
                    obj_item_def_mode_rgb,
                    [obj_item_def_mode_r, obj_item_def_mode_g, obj_item_def_mode_b]
                )
                // if (b_combo) {
                //     obj_item_def_mode_rgb.set_min_val(str_attr_val_min_val);
                // } else {
                //     obj_item_def_mode_r.set_min_val(str_attr_val_min_val);
                //     obj_item_def_mode_g.set_min_val(str_attr_val_min_val);
                //     obj_item_def_mode_b.set_min_val(str_attr_val_min_val);
                // }
            }

            // 显示数据最大值， 整数，浮点数时有效
            var str_attr_val_max_val = obj_param_rsp.get_attr_val(str_param_name, "MAX_VAL");
            if ('undefined' !== typeof str_attr_val_max_val) {
                set_obj_combo_mode(
                    b_combo,
                    'set_max_val',
                    str_attr_val_max_val,
                    obj_item_def_mode_rgb,
                    [obj_item_def_mode_r, obj_item_def_mode_g, obj_item_def_mode_b]
                )
            }

            // 下拉列表的数组
            var str_attr_val_array = obj_param_rsp.get_attr_val(str_param_name, "ARRAY")
            if ('undefined' !== typeof str_attr_val_array) {
                var arr_attr_val_array = [];
                var arr_attr_val_array_split = str_attr_val_array.split(",");
                for (var i = 0; i < arr_attr_val_array_split.length - 1; i++) {
                    arr_attr_val_array.push(arr_attr_val_array_split[i].split("=")[1]);
                }
                // console.log(arr_attr_val_array)
                set_obj_combo_mode(
                    b_combo,
                    'set_array',
                    arr_attr_val_array,
                    obj_item_def_mode_rgb,
                    [obj_item_def_mode_r, obj_item_def_mode_g, obj_item_def_mode_b]
                )
                // obj_item_def_mode_r.set_array(arr_attr_val_array);
            }

            // 步进值
            var str_attr_val_step = obj_param_rsp.get_attr_val(str_param_name, "STEP")
            if ('undefined' !== typeof str_attr_val_step) {
                // obj_item_def_mode_r.set_step_val(str_attr_val_step);
                set_obj_combo_mode(
                    b_combo,
                    'set_step_val',
                    str_attr_val_step,
                    obj_item_def_mode_rgb,
                    [obj_item_def_mode_r, obj_item_def_mode_g, obj_item_def_mode_b]
                )
            }

            // 控件尾部显示字串ID
            var str_attr_val_tail = obj_param_rsp.get_attr_val(str_param_name, "TAIL_ID_LIST");
            if ('undefined' !== str_attr_val_tail) {
                var str_attr_tail_return = '';
                var ary_attr_val_tail = str_attr_val_tail.split(",");
                for (var idx_tail = 0; idx_tail < ary_attr_val_tail.length; idx_tail++) {
                    str_attr_tail_return += get_lang_trans(ary_attr_val_tail[idx_tail]);
                }
                obj_item_unit_lable.set_val(str_attr_tail_return);
            }

            // 控制列样式
            var item_box_class = "item_box flex_box_horizontal"
            switch (ui_col_cnt_def) {
                case 1:
                    item_box_class += " item_box_max_col_one"
                    break;
                case 2:
                    item_box_class += " item_box_max_col_two"
                    break;
                case 3:
                    item_box_class += " item_box_max_col_three"
                    break;
                default:
                    item_box_class += " item_box_max_col_three"
                    break;
            }

            // 最后再设置dom
            str_item_name = obj_item_name_lable.get_html_txt();
            if (b_combo) {
                str_item_itself = "<div class='mc_item_combo flex_box_vertical'>" + obj_item_def_mode_rgb.get_html_txt() + "</div>"
            } else {
                str_item_itself = "<div class='mc_item_no_combo'>" + obj_item_def_mode_r.get_html_txt() + "</div>" +
                    "<div class='mc_item_no_combo'>" + obj_item_def_mode_g.get_html_txt() + "</div>" +
                    "<div class='mc_item_no_combo'>" + obj_item_def_mode_b.get_html_txt() + "</div>";
            }
            str_item_tail = obj_item_unit_lable.get_html_txt();

            // 写入返回出去的html
            var item_html = "";
            item_html =
                "<div class='" + item_box_class + " '" + ">" +
                str_item_name +
                "<div class='flex_box_auto_size mc_edt_inp_wrap'>" + str_item_itself + "</div>" +
                str_item_tail +
                "</div>";
            str_item_dom_list += item_html;
            mc_item_placeholder_div = "<div id='placeholder_div' class='" + item_box_class + "'></div>"
        }
        // 所有组件的组合赋值给定义的字符串dom,通过get_dom_html函数输出
        str_dom_html = str_item_dom_list + mc_item_placeholder_div + mc_item_placeholder_div;
        return true
    }


    this.set_lang_map = function (obj_lang_map) {
        if ("object" !== typeof obj_lang_map) {
            return false;
        }
        m_obj_lang_data = new Object();
        for (var str_key in obj_lang_map) {
            var str_val = obj_lang_map[str_key];
            str_key = str_key.toUpperCase();
            m_obj_lang_data[str_key] = str_val;
        }

        return true;
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    封装所有日志类型并返回转换之后的格式
     * 参数:
     *    @param { Promise<string> } 创建的控件JSON字串
     * 返回：
     *    @returns { Promise<Boolean> } true 设置成功  | false 参数类型错误或为空时
     * 例子：
     *    NA
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.11.8
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_json_txt = function (str_json_txt) {
        if ("string" !== typeof str_json_txt || str_json_txt.trim() === "") {
            return false;
        }
        str_json_txt_re = str_json_txt
        set_json_dom(str_json_txt_re, ui_col_cnt_def)
        return true;
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置一行存放的控件列数
     * 参数:
     *    @param { Promise<number> } 一行存放的列数
     * 返回：
     *    @returns { Promise<Boolean> } true 设置成功  | false 参数类型错误或为空时
     * 例子：
     *    NA
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.11.8
     *      内容 : 所有代码
     ************************************************************************************************/

    this.set_max_col_cnt = function (ui_col_cnt) {
        if ("number" !== typeof ui_col_cnt) {
            return false;
        }
        ui_col_cnt_def = ui_col_cnt
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置控件里面的控件本身是否合并：根据RGB
     * 参数:
     *    @param { Promise<object> } 控件RGB对象
     * 返回：
     *    @returns { Promise<object> } true 设置成功  | false 参数类型错误或为空时
     * 例子：
     *    参数格式：
     *    key=ITEM_ID(NAME_ID), val=true/false 
     *    var obj_combo_mode = {
     *     DISP_MODE: false,
     *     DATA_LEVEL_RATIO: false,
     *     PIX_OUTPUT_BIT_SIZE: true,
     *     PIX_INPUT_BIT_SIZE: true,
     *     DATA_LEVEL_OFFSET: false
     *    };
     * 备注：
     *    默认RGB不合并
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.11.8
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_rgb_combo_mode = function (obj_combo_mode) {
        if ("object" !== typeof obj_combo_mode) {
            return false;
        }
        obj_combo_mode_def = obj_combo_mode
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取生成的dom字符串
     * 参数:
     *    NA
     * 返回：
     *    @returns { Promise<string> } 返回生成的dom字符串
     * 例子：
     *    NA
     * 备注：
     *    NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 巫昭雯
     *      时间 : 2019.11.8
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_dom_html = function () {
        return str_dom_html;
    };
}